<?php
/*--------------------------------------------------------------------
 OnGetSellingUnitWeightEvent.php 2020-2-24
 Gambio GmbH
 http://www.gambio.de
 Copyright (c) 2020 Gambio GmbH
 Released under the GNU General Public License (Version 2)
 [http://www.gnu.org/licenses/gpl-2.0.html]
 -------------------------------------------------------------------*/

namespace Gambio\Shop\SellingUnit\Database\Unit\Events;

use Gambio\Shop\Product\ValueObjects\ProductId;
use Gambio\Shop\ProductModifiers\Modifiers\Collections\ModifierIdentifierCollectionInterface;
use Gambio\Shop\SellingUnit\Core\Events\SellingUnitEventTrait;
use Gambio\Shop\SellingUnit\Database\Unit\Events\Interfaces\OnGetSellingUnitWeightEventInterface;
use Gambio\Shop\SellingUnit\Unit\Builders\Interfaces\SellingUnitBuilderInterface;
use Gambio\Shop\SellingUnit\Unit\Builders\SellingUnitBuilder;
use Gambio\Shop\SellingUnit\Unit\ValueObjects\SellingUnitId;
use Gambio\Shop\SellingUnit\Unit\ValueObjects\Weight;
use ProductDataInterface;

/**
 * Class OnGetSellingUnitWeightEvent
 * @package Gambio\Shop\SellingUnit\Database\Unit\Events
 */
class OnGetSellingUnitWeightEvent implements OnGetSellingUnitWeightEventInterface
{
    /**
     * @var ProductId
     */
    protected $productId;
    
    /**
     * @var ModifierIdentifierCollectionInterface
     */
    protected $modifiers;
    
    /**
     * @var ProductDataInterface
     */
    protected $product;
    
    /**
     * @var Weight
     */
    protected $weight;
    
    
    /**
     * OnGetSellingUnitWeightEvent constructor.
     *
     * @param ProductId                             $productId
     * @param ModifierIdentifierCollectionInterface $modifiers
     * @param ProductDataInterface                  $product
     * @param Weight                                $weight
     */
    public function __construct(
        ProductId $productId,
        ModifierIdentifierCollectionInterface $modifiers,
        ProductDataInterface $product,
        Weight $weight
    )
    {
        $this->productId = $productId;
        $this->modifiers = $modifiers;
        $this->product   = $product;
        $this->weight    = $weight;
    }
    
    
    /**
     * @inheritDoc
     */
    public function productId(): ProductId
    {
        return $this->productId;
    }
    
    
    /**
     * @inheritDoc
     */
    public function modifiers(): ModifierIdentifierCollectionInterface
    {
        return $this->modifiers;
    }
    
    
    /**
     * @inheritDoc
     */
    public function product(): ProductDataInterface
    {
        return $this->product;
    }
    
    
    /**
     * @inheritDoc
     */
    public function weight(): Weight
    {
        return $this->weight;
    }
    
    
    /**
     * @inheritDoc
     */
    public function setWeight(Weight $weight): void
    {
        $this->weight = $weight;
    }
}